<?php
include('./config.php');

// Handle file upload
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['csv_file'])) {
    $file = $_FILES['csv_file']['tmp_name'];

    if (($handle = fopen($file, 'r')) !== FALSE) {
        $inserted = 0;
        $skipped = 0;

        while (($data = fgetcsv($handle, 1000, ',')) !== FALSE) {
            $topic = trim($data[0]);

            if (!empty($topic)) {
                // Use prepared statement to avoid SQL injection
                $stmt = $conn->prepare("INSERT INTO blog_topics (topic) VALUES (?)");
                $stmt->bind_param("s", $topic);
                $stmt->execute();

                if ($stmt->affected_rows > 0) {
                    $inserted++;
                } else {
                    $skipped++;
                }

                $stmt->close();
            } else {
                $skipped++;
            }
        }

        fclose($handle);
        echo "<div style='padding:20px'><strong>Upload Completed.</strong><br>Inserted: $inserted<br>Skipped: $skipped</div>";
    } else {
        echo "Error opening file.";
    }
} else {
    echo "No file uploaded.";
}

$conn->close();
?>
